﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace excel
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //check radiobutton1 
            radioButton1.Checked = true;
            //panggil function untuk hidden tabpage1 dan tabpage2
            hideTabPage();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //buat string koneksi dan simpan namafile Excel yang akan di load
            string connectionString = null;
            string namaFile = "barang.xls";
            //setting koneksi berdasarkan drive atau application.StartUpPath
            if (radioButton1.Checked)
            {
                connectionString = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=E:\barang.xls;Extended Properties=""Excel 8.0;HDR=YES;""";
            }
            else
            {
                connectionString = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Application.StartupPath + "\\" + namaFile + ";Extended Properties='Excel 8.0;HDR=YES'";
            }      
            //buat koneksi dan eksekusi          
            OleDbConnection cn = new OleDbConnection(connectionString);
            OleDbDataAdapter cmd = new OleDbDataAdapter("select * from [Sheet1$]", cn);
            //buat dataset ds3 kemudian fill dataset dengan query dari excel pada Sheet1
            DataSet ds3 = new DataSet();
            cmd.Fill(ds3, "abc");
            //tampilkan query ke dalam datagrid kemudian dispose datase
            dataGridView1.DataSource = ds3;
            dataGridView1.DataMember = "abc";
            ds3.Dispose();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //gunakan try dan catch untuk meng-handle kesalahan yang ada
            try
            {
                //cek validasi txtCell1 dan txtCell2 tidak boleh kosong
                if (txtCell1.Text == "" || txtCell2.Text == "")
                {
                    //exit dari aplikasi
                    return;
                }

                //buat koneksi dan kemudian eksekusi berdasarkan query dan cell inputan
                string connectionString = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=E:\barang.xls;Extended Properties=""Excel 8.0;HDR=YES;""";
                OleDbConnection cn = new OleDbConnection(connectionString);               
                OleDbDataAdapter cmd = new OleDbDataAdapter("select * from [Sheet1$" + txtCell1.Text + ":" + txtCell2.Text + "]", cn);
                //buat dataset dan kemudian dataset tersebut di fill berdasarkan query
                //dan di simpan dalam table DataTable1 pada dataSetBarang
                DataSet DataSetBarang = new DataSet();
                cmd.Fill(DataSetBarang, "DataTable1");
                //tampilkan data pada datagrid berdasarkan dataset , kemudian dispose dataset
                dataGridView1.DataSource = DataSetBarang;
                dataGridView1.DataMember = "DataTable1";
                DataSetBarang.Dispose();
            }
            catch (Exception salah)
            {
                //stop proses dan memberitahu kesalahan yang ada
                throw (salah);
            }    
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //cek validasi txtNamaShet
            if (txtNamaSheet.Text == "")
            {
                //stop / break code
                return;
            }

            //buat array list dan variabel boolean 
            ArrayList tampungQueryInsert = new ArrayList();
            bool flagColumn = false ;
            
            //buat string penampung untuk CreateColumn dan Insert data
            string createColumn = "CREATE TABLE " + txtNamaSheet.Text + "(";
            string insertData = "insert into " + txtNamaSheet.Text + " values(";

            //lakukan perulangan berdasarkan jumlah Rows
            for (int i = 0; i < dataGridView1.Rows.Count; i++)
            {
                //lakukan perulangan berdasarkan jumlah Column
                for (int j = 0; j < dataGridView1.ColumnCount; j++)
                {
                    //setelah membaca data maka ambil data pada cell untuk nanti diinsert
                    insertData += "'" + dataGridView1.Rows[i].Cells[j].Value + "',";     
   
                    //bila flagColumn bernilai false maka isi dalam if dijalankan 
                    if (!flagColumn )
                    {
                        //tampung Syntax untuk Create Column
                        createColumn += Convert.ToString( dataGridView1.Columns[j].Name) + " char(255)" + ",";
                    }
                }
                //potong huruf terakhir ',' pada String agar valid untuk diinsert
                insertData = insertData.Substring(0, insertData.Length - 1) + ")";
               //tambah ke dalam ArrayList
                tampungQueryInsert.Add(insertData);
                //set Default isi string insertData
                insertData = "insert into " + txtNamaSheet.Text + " values(";

                //bila flagColumn bernilai false maka isi dalam if dijalankan 
                if (!flagColumn)
                {
                    //hapus huruf terakhir ',' pada string CreateColumn agar valid untuk diinsert
                    createColumn = createColumn.Substring(0, createColumn.Length - 1) + ")";
                }
                //set flagColumn bernilai true
                flagColumn = true;
            }
            //buat koneksi
            System.Data.OleDb.OleDbConnection connExcel = new System.Data.OleDb.OleDbConnection(@"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=E:\coba.xls;Extended Properties=""Excel 8.0;HDR=YES;""");
            // Buka Koneksi
            connExcel.Open();
            // Buat Command
            System.Data.OleDb.OleDbCommand cmdExcel = new System.Data.OleDb.OleDbCommand();

            //set koneksi dan command yang akan digunakan pada command
            cmdExcel.Connection = connExcel;
            cmdExcel.CommandText = Convert.ToString(createColumn);
            //exekusi command
            cmdExcel.ExecuteNonQuery();

            //baca setiap data yang ada pada ArrayList
            //kemudian data tersebut kita insert
            foreach (object objInsert in tampungQueryInsert)
            {      
                    cmdExcel.CommandText = Convert.ToString(objInsert);
                    cmdExcel.ExecuteNonQuery();              
            }
            //tutupKoneksi
            connExcel.Close();
        }
        
        //buat suatu sub untuk hidden tab
        private void hideTabPage()
        {
            //hidden tabPage1 dan tabPage2
            tabControl1.TabPages.Remove(tabPage1);
            tabControl1.TabPages.Remove(tabPage2);
        }
        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            //cek Treeview yang di klik
            //indeks pada Treeview di mulai dari indeks 0 bukan 1
            if (treeView1.SelectedNode.Index == 0)
            {
                // fanggil function hiddenTabPage , kemudian add tabPage1 
                //kemudian select TabPage pertama
                hideTabPage();
                tabControl1.TabPages.Add(tabPage1);
                tabControl1.SelectedIndex = 0;    
            }
            else if (treeView1.SelectedNode.Index == 1)
            {
                // fanggil function hiddenTabPage , kemudian add tabPage2 
                //kemudian select TabPage pertama
                hideTabPage();
                tabControl1.TabPages.Add(tabPage2);
                tabControl1.SelectedIndex = 0;
            }
            else if (treeView1.SelectedNode.Index == 2)
            {
                //buat messageBox untuk exit dengan option Yes / No untuk exit dari aplikasi
                if (MessageBox.Show("Anda Ingin exit dari aplikasi ?", "Exit Menu", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    //memberi message
                    MessageBox.Show("Terima Kasih telah membaca artikel ini");
                    //exit Dari Aplikasi
                    Environment.Exit(1);
                }
            }         
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //membuka Link dengan sumber link dari namaLinkLabel itu sendiri
            System.Diagnostics.Process.Start(linkLabel1.Text);
        }

        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //membuka Link dengan sumber link dari namaLinkLabel itu sendiri
            System.Diagnostics.Process.Start(linkLabel2.Text);
        }

        private void linkLabel3_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //membuka Link dengan sumber link dari namaLinkLabel itu sendiri
            System.Diagnostics.Process.Start(linkLabel3.Text);
        }
    }
}
